<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Include the configuration files.
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

// Make sure that the person is logged in.
require ("./loginverify.php");

/*
 * Include the functions. Start the page timer, output the opening HTML,
 * and verify that we can actually connect to the database.
*/
require ("./functions.php");
	$start_time = micro_time(0);
	bodyHeader('index', $version_num);
	bodyNavigation('index');
	check_db_connection($adlogger_db_connect, $adlogger_db_select);

/*
 * Grab the click stats from the QuickStats table
 */
$sql = "SELECT *
			FROM " . $db_table_prefix . "quickstats
				WHERE id = 1
					";
$result = mysql_query($sql);
$row = mysql_fetch_array($result);
	$last_update_time = $row['last_update_time'];
		$date = date('M jS, Y', $last_update_time);
		$time = date('g:i:s A', $last_update_time);
	$click_count_today = $row['index.today.total'];
	$unique_visitors_click_today = $row['index.today.unique'];
	$ad_clicks_today = $row['index.today.ads'];
	$link_clicks_today = $row['index.today.links'];

	$click_count_yesterday = $row['index.yesterday.total'];
	$unique_visitors_click_yesterday = $row['index.yesterday.unique'];
	$ad_clicks_yest = $row['index.yesterday.ads'];
	$link_clicks_yest = $row['index.yesterday.links'];

	$click_count_week = $row['index.week.total'];
	$unique_visitors_click_week = $row['index.week.unique'];
	$ad_clicks_week = $row['index.week.ads'];
	$link_clicks_week = $row['index.week.links'];

	$click_count_overall = $row['index.overall.total'];
	$unique_visitors_click = $row['index.overall.unique'];
	$ad_clicks_overall = $row['index.overall.ads'];
	$link_clicks_overall = $row['index.overall.links'];
?>

<div id="side-bar">
	<div>
		<p class="sideBarTitle">Performance Overview</p>
	</div>
</div>

<div id="main-copy">
	<h1 id="overview">Overview</h1>
	<p>&nbsp;</p>
	
	<div align="center">
		<table summary="overview" width="75%" id="greytable">

			<thead id="greythead">
				<tr>
					<th scope="col" width="20%">Date</th>
					<th scope="col" width="20%">Total Clicks</th>
					<th scope="col" width="20%">Unique Clicks</th>
					<th scope="col" width="20%">Ad Units</th>
					<th scope="col" width="20%">Link Units</th>
				</tr>
			</thead>	

			<tbody id="greytbody">
				<tr>
					<th scope="row"><a href="./archive.php?sortnum=10&amp;begin_date=<?php echo urlencode(date('m/d/Y', $timestamp)); ?>&amp;end_date=">Today</a></th>
					<td><?php echo number_format($click_count_today); ?></td>
					<td><?php echo number_format($unique_visitors_click_today); ?></td>
					<td><?php echo number_format($ad_clicks_today); ?></td>
					<td><?php echo number_format($link_clicks_today); ?></td>
				</tr>
				<tr class="odd">
					<th scope="row"><a href="./archive.php?sortnum=10&amp;begin_date=<?php echo urlencode(date('m/d/Y', $timestamp - 24*60*60)); ?>&amp;end_date=">Yesterday</a></th>
					<td><?php echo number_format($click_count_yesterday); ?></td>
					<td><?php echo number_format($unique_visitors_click_yesterday); ?></td>
					<td><?php echo number_format($ad_clicks_yest); ?></td>
					<td><?php echo number_format($link_clicks_yest); ?></td>
				</tr>
				<tr class="odd">
					<th scope="row"><a href="./archive.php?sortnum=10&amp;begin_date=<?php echo urlencode(date('m/d/Y', $timestamp - 7*24*60*60)); ?>&amp;end_date=<?php echo urlencode(date('m/d/Y', $timestamp)); ?>">This Week</a></th>
					<td><?php echo number_format($click_count_week); ?></td>
					<td><?php echo number_format($unique_visitors_click_week); ?></td>
					<td><?php echo number_format($ad_clicks_week); ?></td>
					<td><?php echo number_format($link_clicks_week); ?></td>
				</tr>
				<tr class="odd">
					<th scope="row"><a href="./all_clicks.php">Overall</a></th>
					<td><?php echo number_format($click_count_overall); ?></td>
					<td><?php echo number_format($unique_visitors_click); ?></td>
					<td><?php echo number_format($ad_clicks_overall); ?></td>
					<td><?php echo number_format($link_clicks_overall); ?></td>
				</tr>
			</tbody>

		</table>
		<br />
		These stats were last updated at <?php echo "<strong>" . $time . "</strong>" . " on <strong>" . $date . "</strong>"; ?>.  Click <a href="./update_stats.php?update=index&amp;ref=<?php echo $_SERVER['REQUEST_URI']; ?>">here</a> to update them.
	</div>

	<h1 id="report">Report</h1>
	<p>AdLogger has reported a total of <?php echo number_format($click_count_overall); ?> clicks. This includes the number of clicks on ad units, <?php echo number_format($ad_clicks_overall); ?>, as well as link units, <?php echo number_format($link_clicks_overall); ?>. You may or may not have registered that many clicks on your official account page, but that is the approximate number of click-throughs that AdLogger recorded for each format. Your official account will not record any clicks on link units unless a click is made on the subsequent landing page.</p>
	<p>Of those <?php echo number_format($click_count_overall); ?> clicks, only <?php echo number_format($unique_visitors_click); ?> were from unique IP addresses.  That means that each visitor clicked an average of <?php if ($unique_visitors_click > 0) { echo round($click_count_overall / $unique_visitors_click, 3); } else { echo 0; } ?> ads. You can learn even more about these numbers by examining your click logs for each individual visitor within this administration panel.</p>

</div>

<?php bodyFooter('index', $start_time); ?>